/*
* @category    Modulo Asignacion Citas Web
* @package     Nube Apps - OfiClinic
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@nubeapps.com.co>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Ver 1.0
* @license     COMERCIAL
* @link        http://www.nubeapps.com.co
* @country     Colombia
* @telephone   3168345866
*/
var tieneInasistencias = 0;
var wCAS = 0;
var wCliente = 0;
var wPlan = 0;
var wSubPlan = 0;
var wContrato = 0;
var wPrograma = 0;
var wConcepto = 0;
var wTipoAtencion = 0;
var wTiempoMinimo = 0;
var wFechaEstudio = "";
var wDiasTranscurridos = 0;
var wTipoCita = "";

$(function() {
    
    setInterval("descSesion()",300000);
    
    $("#gridHistorial").jsGrid({
        //height: "auto",
        height: 270,
        width: "100%",
        filtering: false,
        inserting: false,
        editing: false,
        sorting: false,
        paging: false,
        autoload: false,
        pageSize: 500,
        pageButtonCount: 5,
        pagerFormat: "Paginas: {first} {prev} {pages} {next} {last}    {pageIndex} de {pageCount}",
        pagePrevText: "<-Anterior",
        pageNextText: "Siguiente->",
        pageFirstText: "Primera",
        pageLastText: "Ultima",
        pageNavigatorNextText: "...",
        pageNavigatorPrevText: "...",
        deleteConfirm: "Esta seguro que desea eliminar el registro?",
        noDataContent: "No existen datos para mostrar...!",
        controller: {
            loadData: function(filter) {
                return $.ajax({
                    type: "GET",
                    url: "function/controller.php",
                    contentType: "application/json",
                    dataType: "json",
                    data: {
                        task: 'HISTORIAL_CITAS',
                        pPaciente: sessionStorage.getItem("pPaciente")
                    },
                    success: function (data) {
                        //
                    }
                });
            },
            insertItem: function(item) {
                //
            },
            updateItem: function(item) {
                //
            },
            deleteItem: function(item) {
                //
            }
        },
        fields: [
            //{ name: "IPS", title: "IPS", width: 70, sorting: false, filtering: false, align: "center"}
            { name: "IPS", title: "IPS", sorting: false, filtering: false},
            { name: "FecCita", title: "Fecha", sorting: false, filtering: false, align: "center"},
            { name: "DesCita", title: "Hora", sorting: false, filtering: false, align: "center"},
            { name: "Profesional", title: "Profesional", sorting: false, filtering: false},
            { name: "CAS", title: "CAS", sorting: false, filtering: false, align: "center"},
            { name: "DescProcedimiento", title: "Servicio", sorting: false, filtering: false},
            { name: "Programa", title: "Programa", sorting: false, filtering: false},
            { name: "Cliente", title: "Entidad - EPS", sorting: false, filtering: false}
        ]
    });
    
    $("#gridCopagos").jsGrid({
        //height: "auto",
        height: 270,
        width: "100%",
        filtering: false,
        inserting: false,
        editing: false,
        sorting: false,
        paging: false,
        autoload: false,
        pageSize: 500,
        pageButtonCount: 5,
        pagerFormat: "Paginas: {first} {prev} {pages} {next} {last}    {pageIndex} de {pageCount}",
        pagePrevText: "<-Anterior",
        pageNextText: "Siguiente->",
        pageFirstText: "Primera",
        pageLastText: "Ultima",
        pageNavigatorNextText: "...",
        pageNavigatorPrevText: "...",
        deleteConfirm: "Esta seguro que desea eliminar el registro?",
        noDataContent: "No existen datos para mostrar...!",
        controller: {
            loadData: function(filter) {
                return $.ajax({
                    type: "GET",
                    url: "function/controller.php",
                    contentType: "application/json",
                    dataType: "json",
                    data: {
                        task: 'COPAGOS_PENDIENTES',
                        pPaciente: sessionStorage.getItem("pPaciente")
                    },
                    success: function (data) {
                        //
                    }
                });
            },
            insertItem: function(item) {
                //
            },
            updateItem: function(item) {
                //
            },
            deleteItem: function(item) {
                //
            }
        },
        fields: [
            //{ name: "IPS", title: "IPS", width: 70, sorting: false, filtering: false, align: "center"}
            { name: "IPS", title: "IPS", sorting: false, filtering: false},
            { name: "Fecha", title: "Fecha", sorting: false, filtering: false, align: "center"},
            { name: "NomCliente", title: "Entidad - EPS", sorting: false, filtering: false},
            { name: "Concepto", title: "Concepto", sorting: false, filtering: false},
            { name: "VlrConcepto", title: "VlrConcepto", sorting: false, filtering: false, align: "center"}
        ]
    });
    
    $("#gridInasistencias").jsGrid({
        //height: "auto",
        height: 270,
        width: "100%",
        filtering: false,
        inserting: false,
        editing: false,
        sorting: false,
        paging: false,
        autoload: false,
        pageSize: 500,
        pageButtonCount: 5,
        pagerFormat: "Paginas: {first} {prev} {pages} {next} {last}    {pageIndex} de {pageCount}",
        pagePrevText: "<-Anterior",
        pageNextText: "Siguiente->",
        pageFirstText: "Primera",
        pageLastText: "Ultima",
        pageNavigatorNextText: "...",
        pageNavigatorPrevText: "...",
        deleteConfirm: "Esta seguro que desea eliminar el registro?",
        noDataContent: "No existen datos para mostrar...!",
        controller: {
            loadData: function(filter) {
                return $.ajax({
                    type: "GET",
                    url: "function/controller.php",
                    contentType: "application/json",
                    dataType: "json",
                    data: {
                        task: 'CHECK_INASISTENCIA',
                        pPaciente: sessionStorage.getItem("pPaciente")
                    },
                    success: function (data) {
                        tieneInasistencias = 0;
                        $.each(data, function(index, element) {
                            tieneInasistencias ++;
                        });
                        if(tieneInasistencias > 0){
                            $("#NoInasistencia").css("display", "none");
                            $("#NoInasistencia1").css("display", "block");
                            $("#gridInasistencias").css("display", "block");
                            $("#dvDeseaAsignarCita").css("display", "none");
                            $("#cbProfesional").css("display", "none");
                            $("#cbFecha").css("display", "none");
                            $("#cbHora").css("display", "none");
                            $("#sysBtnAsignarCita").css("display", "none");
                            $("#sysBtnAsignarCita").css("display", "none");
                            activaTab('tab-inasistencias');
                            alertify.set({ delay: 10000 });
                            alertify.error("Tienes inasistencias y debes acercarte a la IPS de tu atención para que realices el taller pedagógico o pagues tu multa odontológica.");
                        }else{
                            $("#NoInasistencia").css("display", "block");
                            $("#NoInasistencia1").css("display", "none");
                            $("#gridInasistencias").css("display", "none");
                            $("#dvDeseaAsignarCita").css("display", "block");
                            $("#cbProfesional").css("display", "none");
                            $("#cbFecha").css("display", "none");
                            $("#cbHora").css("display", "none");
                            $("#sysBtnAsignarCita").css("display", "none");
                        }
                        $("#gridCancelarCitas").jsGrid("loadData");
                    }
                });
            },
            insertItem: function(item) {
                //
            },
            updateItem: function(item) {
                //
            },
            deleteItem: function(item) {
                //
            }
        },
        fields: [
            //{ name: "IPS", title: "IPS", width: 70, sorting: false, filtering: false, align: "center"}
            { name: "IPS", title: "IPS", sorting: false, filtering: false},
            { name: "Origen", title: "Origen", sorting: false, filtering: false},
            { name: "FecCita", title: "Fecha", sorting: false, filtering: false, align: "center"},
            { name: "DesCita", title: "Hora", sorting: false, filtering: false, align: "center"},
            { name: "Profesional", title: "Profesional", sorting: false, filtering: false},
            { name: "CAS", title: "CAS", sorting: false, filtering: false, align: "center"},
            { name: "Cliente", title: "Entidad - EPS", sorting: false, filtering: false}
        ]
    });
    
    $("#gridCancelarCitas").jsGrid({
        //height: "auto",
        height: 470,
        width: "100%",
        filtering: false,
        inserting: false,
        editing: false,
        sorting: false,
        paging: false,
        autoload: false,
        pageSize: 500,
        pageButtonCount: 5,
        pagerFormat: "Paginas: {first} {prev} {pages} {next} {last}    {pageIndex} de {pageCount}",
        pagePrevText: "<-Anterior",
        pageNextText: "Siguiente->",
        pageFirstText: "Primera",
        pageLastText: "Ultima",
        pageNavigatorNextText: "...",
        pageNavigatorPrevText: "...",
        //deleteConfirm: "Esta seguro que desea eliminar el registro?",
        //deleteConfirm: function(args) {
        //    //alert("Personal: " + args.CAS);
        //},
        noDataContent: "No existen datos para mostrar...!",
        controller: {
            loadData: function(filter) {
                return $.ajax({
                    type: "GET",
                    url: "function/controller.php",
                    contentType: "application/json",
                    dataType: "json",
                    data: {
                        task: 'CHECK_CITASXCANCELAR',
                        pPaciente: sessionStorage.getItem("pPaciente")
                    },
                    success: function (data) {
                        var tieneCitas = 0;
                        $.each(data, function(index, element) {
                            tieneCitas ++;
                        });
                        if(tieneInasistencias > 0){
                            $("#dvDeseaAsignarCita").css("display", "none");
                            activaTab('tab-inasistencias');
                            if(tieneCitas > 0){
                                $("#NoCancelar").css("display", "none");
                                $("#gridCancelarCitas").css("display", "block");
                            }else{
                                $("#NoCancelar").css("display", "block");
                                $("#gridCancelarCitas").css("display", "none");
                            }
                        }else{
                            if(tieneCitas > 0){
                                $("#NoCancelar").css("display", "none");
                                if(tieneInasistencias > 0){
                                    $("#dvDeseaAsignarCita").css("display", "none");
                                }else{
                                    $("#dvDeseaAsignarCita").css("display", "block");
                                }
                                alertify.alert("Ya tienes citas asignadas te invitamos a verificarlas y cancelarlas antes de poder realizar la asignación de tu próxima cita.", function () {
                                    activaTab('tab-cancelarcita');
                                    $("#gridCancelarCitas").css("display", "block");
                                });
                            }else{
                                $("#NoCancelar").css("display", "block");
                                $("#gridCancelarCitas").css("display", "none");
                            }
                        }
                    }
                });
            },
            insertItem: function(item) {
                //
            },
            updateItem: function(item) {
                //
            },
            deleteItem: function(item) {
                //
            }
        },
        fields: [
           { type: "control", width: 100, modeSwitchButton: false, editButton: false, deleteButton: false,
                itemTemplate: function(value, item) {
                    var $result = jsGrid.fields.control.prototype.itemTemplate.apply(this, arguments);
                    var $customButton = $("<button>")
                    .text('Cancelar')
                    .click(function(e) {
                        alertify.prompt("Desea cancelar la cita Nro: " + item.CAS + ", para el día: " + item.FechaCita, function (e, str) { 
                            if (e){
                                if(str != "" && str != null){
                                    $.ajax({
                                        type: 'POST',
                                        url: "function/controller.php",
                                        data: {
                                            task: 'CANCELAR_CITA',
                                            pPaciente: sessionStorage.getItem("pPaciente"),
                                            pCAS: item.CAS,
                                            pMotivo: str
                                        },
                                        success: function(data){
                                            var response = JSON.parse(data);
                                            if(response['success'] === "true"){
                                                alertify.set({ delay: 10000 });
                                                alertify.success("Se canceló la cita satisfactoriamente.");
                                                $("#gridCancelarCitas").jsGrid("loadData");
                                            }else{
                                                alertify.set({ delay: 5000 });
                                                alertify.error("No podemos cancelar la cita en estos momentos, por favor vuelve a intentarlo.");
                                            }
                                        },
                                        error: function(jqXHR, textStatus, errorThrown) {
                                            alertify.set({ delay: 5000 });
                                            alertify.error("No podemos cancelar la cita en estos momentos, por favor vuelve a intentarlo.");
                                        }
                                    });
                                }else{
                                    alertify.set({ delay: 5000 });
                                    alertify.error("No podemos cancelar la cita porque no escribiste el motivo de la cancelación, vuelve a intentarlo por favor.");
                                }
                            }
                        });
                        e.stopPropagation();
                    });
                    return $result.add($customButton);
                }
            },
            { name: "IPS", title: "IPS", width: 100, sorting: false, filtering: false},
            { name: "FechaCita", width: 100, title: "Fecha", sorting: false, filtering: false, align: "center"},
            { name: "HoraAgenda", width: 100, title: "Hora", sorting: false, filtering: false, align: "center"},
            { name: "TipoAtencion", width: 200, title: "Tipo Cita", sorting: false, filtering: false},
            { name: "Profesional", title: "Profesional", width: 200, sorting: false, filtering: false},
            { name: "CAS", title: "CAS", width: 70, sorting: false, filtering: false, align: "center"},
            { name: "Actividad", title: "Actividad", width: 200, sorting: false, filtering: false},
            { name: "Cliente", title: "Entidad - EPS", width: 200, sorting: false, filtering: false}
        ]
    });
    
    $("#gridInasistencias").jsGrid("loadData");
    $("#gridHistorial").jsGrid("loadData");
    $("#gridCopagos").jsGrid("loadData");
    
    $(".chosen-select").chosen({width: "100%"});
    $('#sysDesaAsignarCita').chosen();
    $('#sysDesaAsignarCita').chosen({ allow_single_deselect: true });
    $('#sysDesaAsignarCita').chosen({ no_results_text: "No existen coincidencias" });
    $('#sysDesaAsignarCita').chosen().change(function(){
        myAnsw = $('#sysDesaAsignarCita').chosen().val();
        $.ajax({
            type: 'POST',
            url: "function/controller.php",
            data: {
                task: 'DESEA_ASIGNARCITA',
                pPaciente: sessionStorage.getItem("pPaciente"),
                pOPC: myAnsw
            },
            success: function(data){
                var response = JSON.parse(data);
                if(response['success'] === "true"){
                    //response['pPaciente']
                    if(myAnsw == "NO"){
                        $("#NoAsignar1").css("display", "none");
                        $("#NoAsignar2").css("display", "none");
                        $("#NoAsignar3").css("display", "none");
                        $("#NoAsignar4").css("display", "none");
                        $("#detalelCita").css("display", "none");
                        $("#dvTipoCita").css("display", "none");
                        $("#cbProfesional").css("display", "none");
                        $("#cbFecha").css("display", "none");
                        $("#cbHora").css("display", "none");
                        $("#sysBtnAsignarCita").css("display", "none");
                    }else{
                        $("#NoAsignar1").css("display", "none");
                        $("#NoAsignar2").css("display", "none");
                        $("#NoAsignar3").css("display", "none");
                        $("#NoAsignar4").css("display", "none");
                        $("#detalelCita").css("display", "none");
                        //$("#detalelCita").css("display", "block");
                        $("#dvTipoCita").css("display", "block");
                        $("#cbProfesional").css("display", "none");
                        $("#cbFecha").css("display", "none");
                        $("#cbHora").css("display", "none");
                        $("#sysBtnAsignarCita").css("display", "none");
                    }
                    $('#sysTipoCita').val(null).trigger('chosen:updated');
                }else{
                    $('#sysDesaAsignarCita').val(null).trigger('chosen:updated');
                    $('#sysTipoCita').val(null).trigger('chosen:updated');
                    $("#NoAsignar1").css("display", "none");
                    $("#NoAsignar2").css("display", "none");
                    $("#NoAsignar3").css("display", "none");
                    $("#NoAsignar4").css("display", "none");
                    $("#detalelCita").css("display", "none");
                    $("#dvTipoCita").css("display", "none");
                    $("#NoAsignar1").css("display", "block");
                    $("#cbProfesional").css("display", "none");
                    $("#cbFecha").css("display", "none");
                    $("#cbHora").css("display", "none");
                    $("#sysBtnAsignarCita").css("display", "none");
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                $('#sysDesaAsignarCita').val(null).trigger('chosen:updated');
                $("#NoAsignar1").css("display", "none");
                $("#NoAsignar2").css("display", "none");
                $("#NoAsignar3").css("display", "none");
                $("#NoAsignar4").css("display", "none");
                $("#dvTipoCita").css("display", "none");
                $("#detalelCita").css("display", "none");
                $("#NoAsignar1").css("display", "block");
                $("#cbProfesional").css("display", "none");
                $("#cbFecha").css("display", "none");
                $("#cbHora").css("display", "none");
                $("#sysBtnAsignarCita").css("display", "none");
            }
        });
    });
    $('#sysTipoCita').chosen().change(function(){
        myAnsw = $('#sysTipoCita').chosen().val();
        wTipoCita = myAnsw;
        $.ajax({
            type: 'POST',
            url: "function/controller.php",
            dataType: "json",
            data: {
                task: 'CHECK_CITASXORIGEN',
                pPaciente: sessionStorage.getItem("pPaciente"),
                pTipo: myAnsw
            },
            success: function(data){
                var tieneCitas = 0;
                wCAS = 0;
                wPaciente = 0;
                wCliente = 0;
                wPlan = 0;
                wSubPlan = 0;
                wContrato = 0;
                wPrograma = 0;
                wConcepto = 0;
                wTipoAtencion = 0;
                wTiempoMinimo = 0;
                wFechaEstudio = "";
                wDiasTranscurridos = 0;
                
                $.each(data, function(index, element) {
                    tieneCitas ++;
                    //alert(tieneCitas);
                    wCAS = element.CAS;
                    wPaciente = element.Paciente;
                    wCliente = element.Cliente;
                    wPlan = element.Plan;
                    wSubPlan = element.SubPlan;
                    wContrato = element.Contrato;
                    wPrograma = element.Programa;
                    wConcepto = element.IdProced;
                    wTipoAtencion = element.TipoAtencion;
                    wTiempoMinimo = element.TiempoMinimo;
                    wFechaEstudio = element.FechaEstudio;
                    wDiasTranscurridos = element.DiasTranscurridos;
                });
                if(parseInt(wPaciente) > 0){
                    if(parseInt(tieneCitas) > 0){
                        if(wDiasTranscurridos > wTiempoMinimo){
                        //if(wDiasTranscurridos < 0){
                            $('#sysTipoCita').val(null).trigger('chosen:updated');
                            $("#NoAsignar1").css("display", "none");
                            $("#NoAsignar2").css("display", "block");
                            $("#NoAsignar3").css("display", "none");
                            $("#NoAsignar4").css("display", "none");
                            $("#detalelCita").css("display", "none");
                            $("#cbProfesional").css("display", "none");
                            $("#cbFecha").css("display", "none");
                            $("#cbHora").css("display", "none");
                            $("#sysBtnAsignarCita").css("display", "none");
                            $.ajax({
                                type: 'POST',
                                url: "function/controller.php",
                                data: {
                                    task: 'DESEA_ASIGNARCITA',
                                    pPaciente: sessionStorage.getItem("pPaciente"),
                                    pOPC: "NO"
                                },
                                success: function(data){
                                    var response = JSON.parse(data);
                                    if(response['success'] === "true"){
                                        $("#NoAsignar1").css("display", "none");
                                        $("#NoAsignar3").css("display", "none");
                                        $("#NoAsignar4").css("display", "none");
                                        $("#detalelCita").css("display", "none");
                                        $("#dvTipoCita").css("display", "none");
                                        $("#cbProfesional").css("display", "none");
                                        $("#cbFecha").css("display", "none");
                                        $("#cbHora").css("display", "none");
                                        $("#sysBtnAsignarCita").css("display", "none");
                                        $('#sysDesaAsignarCita').val(null).trigger('chosen:updated');
                                        $('#sysTipoCita').val(null).trigger('chosen:updated');
                                    }else{
                                        $('#sysDesaAsignarCita').val(null).trigger('chosen:updated');
                                        $('#sysTipoCita').val(null).trigger('chosen:updated');
                                        $("#NoAsignar1").css("display", "none");
                                        $("#NoAsignar3").css("display", "none");
                                        $("#NoAsignar4").css("display", "none");
                                        $("#detalelCita").css("display", "none");
                                        $("#dvTipoCita").css("display", "none");
                                        $("#cbProfesional").css("display", "none");
                                        $("#cbFecha").css("display", "none");
                                        $("#cbHora").css("display", "none");
                                        $("#sysBtnAsignarCita").css("display", "none");
                                    }
                                },
                                error: function(jqXHR, textStatus, errorThrown) {
                                    $('#sysDesaAsignarCita').val(null).trigger('chosen:updated');
                                    $('#sysTipoCita').val(null).trigger('chosen:updated');
                                    $("#NoAsignar1").css("display", "none");
                                    $("#NoAsignar3").css("display", "none");
                                    $("#NoAsignar4").css("display", "none");
                                    $("#dvTipoCita").css("display", "none");
                                    $("#detalelCita").css("display", "none");
                                    $("#cbProfesional").css("display", "none");
                                    $("#cbFecha").css("display", "none");
                                    $("#cbHora").css("display", "none");
                                    $("#sysBtnAsignarCita").css("display", "none");
                                }
                            });
                        }else{
                            $("#NoAsignar1").css("display", "none");
                            $("#NoAsignar2").css("display", "none");
                            $("#NoAsignar3").css("display", "none");
                            $("#NoAsignar4").css("display", "none");
                            $("#cbProfesional").css("display", "none");
                            $("#cbFecha").css("display", "none");
                            $("#cbHora").css("display", "none");
                            $("#sysBtnAsignarCita").css("display", "none");
                            verificarParametrosCita(wCAS, wPaciente, wCliente, wPlan, wSubPlan, wContrato, wPrograma, wTipoAtencion, wTiempoMinimo, wFechaEstudio, wDiasTranscurridos, wTipoCita);
                        }
                    }else{
                        $("#NoAsignar1").css("display", "none");
                        $("#NoAsignar2").css("display", "none");
                        $("#NoAsignar3").css("display", "none");
                        $("#NoAsignar4").css("display", "none");
                        $("#cbProfesional").css("display", "none");
                        $("#cbFecha").css("display", "none");
                        $("#cbHora").css("display", "none");
                        $("#sysBtnAsignarCita").css("display", "none");
                        verificarParametrosCita(wCAS, wPaciente, wCliente, wPlan, wSubPlan, wContrato, wPrograma, wTipoAtencion, wTiempoMinimo, wFechaEstudio, wDiasTranscurridos, wTipoCita);
                    }
                }else{
                    if(wTipoCita == "MEDICINA"){
                        alertify.set({ delay: 5000 });
                        alertify.error("<strong>Atencion!</strong> En los últimos seis meses no has asistido a consulta medica general, debes solicitarla de forma presencial o telefónica.!.");
                    }else{
                        alertify.set({ delay: 5000 });
                        alertify.error("<strong>Atencion!</strong> En los últimos seis meses no has asistido a consulta odontologica general, debes solicitarla de forma presencial o telefónica.!.");
                    }
                    /*
                    if(wTipoCita == "MEDICINA"){
                        $("#NoAsignar3").css("display", "block");
                    }else{
                        $("#NoAsignar4").css("display", "block");
                    }
                     */
                    $("#NoAsignar1").css("display", "none");
                    $("#NoAsignar2").css("display", "none");
                    $("#NoAsignar3").css("display", "none");
                    $("#NoAsignar4").css("display", "none");
                    $("#detalelCita").css("display", "none");
                    $("#dvTipoCita").css("display", "none");
                    $("#cbProfesional").css("display", "none");
                    $("#cbFecha").css("display", "none");
                    $("#cbHora").css("display", "none");
                    $("#sysBtnAsignarCita").css("display", "none");
                    $.ajax({
                        type: 'POST',
                        url: "function/controller.php",
                        data: {
                            task: 'DESEA_ASIGNARCITA',
                            pPaciente: sessionStorage.getItem("pPaciente"),
                            pOPC: "NO"
                        },
                        success: function(data){
                            var response = JSON.parse(data);
                            if(response['success'] === "true"){
                                $("#NoAsignar1").css("display", "none");
                                $("#NoAsignar2").css("display", "none");
                                $("#NoAsignar3").css("display", "none");
                                $("#NoAsignar4").css("display", "none");
                                $("#detalelCita").css("display", "none");
                                $("#dvTipoCita").css("display", "none");
                                $("#cbProfesional").css("display", "none");
                                $("#cbFecha").css("display", "none");
                                $("#cbHora").css("display", "none");
                                $("#sysBtnAsignarCita").css("display", "none");
                                $('#sysDesaAsignarCita').val(null).trigger('chosen:updated');
                                $('#sysTipoCita').val(null).trigger('chosen:updated');
                            }else{
                                $('#sysDesaAsignarCita').val(null).trigger('chosen:updated');
                                $('#sysTipoCita').val(null).trigger('chosen:updated');
                                $("#NoAsignar1").css("display", "none");
                                $("#NoAsignar2").css("display", "none");
                                $("#NoAsignar3").css("display", "none");
                                $("#NoAsignar4").css("display", "none");
                                $("#detalelCita").css("display", "none");
                                $("#dvTipoCita").css("display", "none");
                                $("#cbProfesional").css("display", "none");
                                $("#cbFecha").css("display", "none");
                                $("#cbHora").css("display", "none");
                                $("#sysBtnAsignarCita").css("display", "none");
                            }
                        },
                        error: function(jqXHR, textStatus, errorThrown) {
                            $('#sysDesaAsignarCita').val(null).trigger('chosen:updated');
                            $('#sysTipoCita').val(null).trigger('chosen:updated');
                            $("#NoAsignar1").css("display", "none");
                            $("#NoAsignar2").css("display", "none");
                            $("#NoAsignar3").css("display", "none");
                            $("#NoAsignar4").css("display", "none");
                            $("#dvTipoCita").css("display", "none");
                            $("#detalelCita").css("display", "none");
                            $("#cbProfesional").css("display", "none");
                            $("#cbFecha").css("display", "none");
                            $("#cbHora").css("display", "none");
                            $("#sysBtnAsignarCita").css("display", "none");
                        }
                    });
                    
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                $('#sysTipoCita').val(null).trigger('chosen:updated');
                alertify.set({ delay: 5000 });
                alertify.error("No podemos verificar las citas que tienes asignadas, vuelve a intentarlo por favor.");
            }
        });
    });
    
});

function verificarParametrosCita(wCAS, wPaciente, wCliente, wPlan, wSubPlan, wContrato, wPrograma, wTipoAtencion, wTiempoMinimo, wFechaEstudio, wDiasTranscurridos, wTipoCita){
    $("#detalelCita").css("display", "block");
    $.ajax({
        type: 'POST',
        url: "function/controller.php",
        dataType: "json",
        data: {
            task: 'LISTAR_PROFESIONALESAGENDA',
            Paciente: wPaciente,
            TipoCita: wTipoCita
        },
        async: false,
        beforeSend: function (xhr) {
            if (xhr && xhr.overrideMimeType) {
                xhr.overrideMimeType('application/json;charset=utf-8');
            }
        },
        success: function (data) {
            myData = data;
            $("#sysProfesionalCita").html('');
            $.each(myData, function(index, combo){
                $("#sysProfesionalCita").append('<option value="' + combo.Codigo + '">' + combo.Descripcion + '</option>');
            });
            $("#sysProfesionalCita").chosen().trigger("liszt:updated");
            $('#sysProfesionalCita').chosen().trigger("chosen:updated");
            $('#sysProfesionalCita').val(null).trigger('chosen:updated');
            $("#cbProfesional").css("display", "block");
            $("#sysBtnAsignarCita").css("display", "none");
        }
    });
   
    $("#sysProfesionalCita").chosen().change(function(){
        $("#cbFecha").css("display", "none");
        $("#sysFechaCita").append('<option value=""></option>');
        $("#sysFechaCita").chosen().trigger("liszt:updated");
        $('#sysFechaCita').chosen().trigger("chosen:updated");
        $('#sysFechaCita').val(null).trigger('chosen:updated');
        
        $("#cbHora").css("display", "none");
        $("#sysHoraCita").append('<option value=""></option>');
        $("#sysHoraCita").chosen().trigger("liszt:updated");
        $('#sysHoraCita').chosen().trigger("chosen:updated");
        $('#sysHoraCita').val(null).trigger('chosen:updated');
        $("#sysBtnAsignarCita").css("display", "none");
        
        $.ajax({
            type: 'POST',
            url: "function/controller.php",
            dataType: "json",
            data: {
                task: 'LISTAR_FECHASAGENDA',
                Profesional: $('#sysProfesionalCita').val(),
                Paciente: wPaciente
            },
            async: false,
            beforeSend: function (xhr) {
                if (xhr && xhr.overrideMimeType) {
                    xhr.overrideMimeType('application/json;charset=utf-8');
                }
            },
            success: function (data) {
                myData = data;
                $("#sysFechaCita").html('');
                $.each(myData, function(index, combo){
                    $("#sysFechaCita").append('<option value="' + combo.Codigo + '">' + combo.Descripcion + '</option>');
                });
                $("#sysFechaCita").chosen().trigger("liszt:updated");
                $('#sysFechaCita').chosen().trigger("chosen:updated");
                $('#sysFechaCita').val(null).trigger('chosen:updated');
                $("#cbFecha").css("display", "block");
            }
        });
    });
    $("#sysFechaCita").chosen().change(function(){
        $("#sysBtnAsignarCita").css("display", "none");
        $("#cbHora").css("display", "none");
        $("#sysHoraCita").append('<option value=""></option>');
        $("#sysHoraCita").chosen().trigger("liszt:updated");
        $('#sysHoraCita').chosen().trigger("chosen:updated");
        $('#sysHoraCita').val(null).trigger('chosen:updated');
        $.ajax({
            type: 'POST',
            url: "function/controller.php",
            dataType: "json",
            data: {
                task: 'LISTAR_HORARIOSAGENDA',
                pAgenda: $('#sysFechaCita').val(),
                pCAS: wCAS, 
                pPaciente: wPaciente
            },
            async: false,
            beforeSend: function (xhr) {
                if (xhr && xhr.overrideMimeType) {
                    xhr.overrideMimeType('application/json;charset=utf-8');
                }
            },
            success: function (data) {
                myData = data;
                $("#sysHoraCita").html('');
                $.each(myData, function(index, combo){
                    $("#sysHoraCita").append('<option value="' + combo.Codigo + '">' + combo.Descripcion + '</option>');
                });
                $("#sysHoraCita").chosen().trigger("liszt:updated");
                $('#sysHoraCita').chosen().trigger("chosen:updated");
                $('#sysHoraCita').val(null).trigger('chosen:updated');
                $("#cbHora").css("display", "block");
                $("#sysBtnAsignarCita").css("display", "none");
            }
        });
    });
    $("#sysHoraCita").chosen().change(function(){
        $("#sysBtnAsignarCita").css("display", "block");
    });
}

function asignarCita(){
    $.ajax({
        type: 'POST',
        url: "function/controller.php",
        data: {
            task: 'ASIGNAR_CITA',
            pPaciente: wPaciente,
            pCAS: wCAS,
            pCliente: wCliente,
            pPlan: wPlan,
            pSubPlan: wSubPlan,
            pContrato: wContrato,
            pPrograma: wPrograma,
            pConcepto: wConcepto,
            pProfesional: $('#sysProfesionalCita').val(),
            pFecha: $("#sysFechaCita option:selected").text().substring(0, 10),
            pAgenda: $('#sysFechaCita').val(),
            pHorario: $('#sysHoraCita').val()
        },
        success: function(data){
            var response = JSON.parse(data);
            if(response['success'] === "true"){
                wIdCita = response['IdCita'];
                alertify.alert("Felicitaciones..! Se asignó la cita Nro. " + wIdCita + ", con el profesional: " + $("#sysProfesionalCita option:selected").text() + ", Día: " + $("#sysFechaCita option:selected").text().substring(0, 10) + ", Hora: " + $("#sysHoraCita option:selected").text() + ", por favor verifique esta información a continuación y te recuerdo que puedes cancelar tu cita con 2 horas de anticipación a la consulta. FELIZ DIA", function () {
                    activaTab('tab-historial');
                    $("#gridHistorial").jsGrid("loadData");
                });
                $.ajax({
                    type: 'POST',
                    url: "function/controller.php",
                    data: {
                        task: 'DESEA_ASIGNARCITA',
                        pPaciente: sessionStorage.getItem("pPaciente"),
                        pOPC: "NO"
                    },
                    success: function(data){
                        var response = JSON.parse(data);
                        if(response['success'] === "true"){
                            $("#NoAsignar1").css("display", "none");
                            $("#NoAsignar2").css("display", "none");
                            $("#NoAsignar3").css("display", "none");
                            $("#NoAsignar4").css("display", "none");
                            $("#detalelCita").css("display", "none");
                            $("#dvTipoCita").css("display", "none");
                            $("#cbProfesional").css("display", "none");
                            $("#cbFecha").css("display", "none");
                            $("#cbHora").css("display", "none");
                            $("#sysBtnAsignarCita").css("display", "none");
                            $('#sysDesaAsignarCita').val(null).trigger('chosen:updated');
                            $('#sysTipoCita').val(null).trigger('chosen:updated');
                        }else{
                            $('#sysDesaAsignarCita').val(null).trigger('chosen:updated');
                            $('#sysTipoCita').val(null).trigger('chosen:updated');
                            $("#NoAsignar1").css("display", "none");
                            $("#NoAsignar2").css("display", "none");
                            $("#NoAsignar3").css("display", "none");
                            $("#NoAsignar4").css("display", "none");
                            $("#detalelCita").css("display", "none");
                            $("#dvTipoCita").css("display", "none");
                            $("#NoAsignar1").css("display", "block");
                            $("#cbProfesional").css("display", "none");
                            $("#cbFecha").css("display", "none");
                            $("#cbHora").css("display", "none");
                            $("#sysBtnAsignarCita").css("display", "none");
                        }
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        $('#sysDesaAsignarCita').val(null).trigger('chosen:updated');
                        $("#NoAsignar1").css("display", "none");
                        $("#NoAsignar2").css("display", "none");
                        $("#NoAsignar3").css("display", "none");
                        $("#NoAsignar4").css("display", "none");
                        $("#dvTipoCita").css("display", "none");
                        $("#detalelCita").css("display", "none");
                        $("#NoAsignar1").css("display", "block");
                        $("#cbProfesional").css("display", "none");
                        $("#cbFecha").css("display", "none");
                        $("#cbHora").css("display", "none");
                        $("#sysBtnAsignarCita").css("display", "none");
                    }
                });
            }else{
                jQuery.gritter.add({
                    title: 'MEDICARE IPS..!',
                    text: 'No podemos asignar la cita en estos momento.',
                    class_name: 'growl-error',
                    sticky: false,
                    time: ''
                });
            }
        },
        error: function(jqXHR, textStatus, errorThrown) {
            jQuery.gritter.add({
                title: 'MEDICARE IPS..!',
                text: 'No podemos asignar la cita en estos momento.',
                class_name: 'growl-error',
                sticky: false,
                time: ''
            });
        }
    });
}

function activaTab(tab){
    $('.nav-tabs a[href="#' + tab + '"]').tab('show');
};

function descSesion(){
    $.ajax({
        type: 'POST',
        url: "function/controller.php",
        data: {
            task: 'DESEA_ASIGNARCITA',
            pPaciente: sessionStorage.getItem("pPaciente"),
            pOPC: "NO"
        },
        success: function(data){
            var response = JSON.parse(data);
            if(response['success'] === "true"){
                $("#NoAsignar1").css("display", "none");
                $("#NoAsignar2").css("display", "none");
                $("#NoAsignar3").css("display", "none");
                $("#NoAsignar4").css("display", "none");
                $("#detalelCita").css("display", "none");
                $("#dvTipoCita").css("display", "none");
                $("#cbProfesional").css("display", "none");
                $("#cbFecha").css("display", "none");
                $("#cbHora").css("display", "none");
                $("#sysBtnAsignarCita").css("display", "none");
                $('#sysDesaAsignarCita').val(null).trigger('chosen:updated');
                $('#sysTipoCita').val(null).trigger('chosen:updated');
            }else{
                $('#sysDesaAsignarCita').val(null).trigger('chosen:updated');
                $('#sysTipoCita').val(null).trigger('chosen:updated');
                $("#NoAsignar1").css("display", "none");
                $("#NoAsignar2").css("display", "none");
                $("#NoAsignar3").css("display", "none");
                $("#NoAsignar4").css("display", "none");
                $("#detalelCita").css("display", "none");
                $("#dvTipoCita").css("display", "none");
                $("#NoAsignar1").css("display", "block");
                $("#cbProfesional").css("display", "none");
                $("#cbFecha").css("display", "none");
                $("#cbHora").css("display", "none");
                $("#sysBtnAsignarCita").css("display", "none");
            }
        },
        error: function(jqXHR, textStatus, errorThrown) {
            $('#sysDesaAsignarCita').val(null).trigger('chosen:updated');
            $("#NoAsignar1").css("display", "none");
            $("#NoAsignar2").css("display", "none");
            $("#NoAsignar3").css("display", "none");
            $("#NoAsignar4").css("display", "none");
            $("#dvTipoCita").css("display", "none");
            $("#detalelCita").css("display", "none");
            $("#NoAsignar1").css("display", "block");
            $("#cbProfesional").css("display", "none");
            $("#cbFecha").css("display", "none");
            $("#cbHora").css("display", "none");
            $("#sysBtnAsignarCita").css("display", "none");
        }
    });
}