/*
* @category    Funciones Generales
* @package     Nube Apps - Planificador
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@nubeapps.com.co>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     Planificador Ver 1.0
* @license     COMERCIAL
* @link        http://www.nubeapps.com.co
* @country     Colombia
* @telephone   3168345866
*/

function validarDate(xFecha) {
    var currVal = xFecha;
    if(currVal == ''){
        return false;
    }
    var rxDatePattern = /^(\d{1,2})(\/|-)(\d{1,2})(\/|-)(\d{4})$/;
    var dtArray0 = currVal.match(rxDatePattern); // is format OK?
    if (dtArray0 == null){
        return false;
    }
    dtArray = dtArray0[0].split("/");
    //alert("1. (" + dtArray[0] + ") - 2. (" + dtArray[1] + ") - 3. (" + dtArray[2] + ")");
    dtMonth = dtArray[1];
    dtDay= dtArray[3];
    dtYear = dtArray[5];
    if (dtMonth < 1 || dtMonth > 12){
        return false;
    }else if (dtDay < 1 || dtDay> 31){
        return false;
    }else if ((dtMonth==4 || dtMonth==6 || dtMonth==9 || dtMonth==11) && dtDay ==31){
        return false;
    }else if (dtMonth == 2){
        var isleap = (dtYear % 4 == 0 && (dtYear % 100 != 0 || dtYear % 400 == 0));
        if (dtDay> 29 || (dtDay ==29 && !isleap)){
            return false;
        }
    }
    return true;
}
function ConvertirTxtDate(xFecha) {
  var date = new Date();
  xFec = xFecha.split('/');
  ano = xFec[2];
  mes = parseInt(xFec[1]);
  dia = xFec[0];
  date.setMonth((mes-1),dia); //en javascript los meses van de 0 a 11
  date.setYear(ano);
  return date;
}
function MostrarEdad(yr0, mon0, day0, yr, mon, day, unit, decimal, round){
    var one_day=1000*60*60*24;
    var one_month=1000*60*60*24*30;
    var one_year=1000*60*60*24*30*12;
    today = new Date(yr0, mon0 - 1, day0);
    var pastdate=new Date(yr, mon-1, day);
    var countunit=unit;
    var decimals=decimal;
    var rounding=round;
    finalunit=(countunit=="dias")? one_day : (countunit=="meses")? one_month : one_year;
    decimals=(decimals<=0)? 1 : decimals*10;
    if (unit!="anios"){
        if (rounding=="rounddown")
            return (Math.floor((today.getTime()-pastdate.getTime())/(finalunit)*decimals)/decimals);
        else
            return (Math.ceil((today.getTime()-pastdate.getTime())/(finalunit)*decimals)/decimals);
    } else{
        yearspast = today.getFullYear()-yr-1;
        tail=(today.getMonth()>mon-1 || today.getMonth()==mon-1 && today.getDate()>=day)? 1 : 0;
        pastdate.setFullYear(today.getFullYear());
        pastdate2= new Date(today.getFullYear()-1, mon-1, day);
        tail=(tail==1)? tail+Math.floor((today.getTime()-pastdate.getTime())/(finalunit)*decimals)/decimals : Math.floor((today.getTime()-pastdate2.getTime())/(finalunit)*decimals)/decimals ;
        return (yearspast+tail);
    }
}
function MostrarEdadCompleta(Fecha1, Fecha2){
    xanio = 0;
    xmes = 0;
    xdia = 0;
    if(typeof(Fecha1)=='string'){
        xhoy = new Date();
        if(parseInt(Fecha1.substring(0, 4))>1900){
            mes = Fecha1.substring(5, 7);
            xhoy.setMonth(mes - 1); //en javascript los meses van de 0 a 11
            xhoy.setDate(Fecha1.substring(8, 10));
            xhoy.setYear(Fecha1.substring(0, 4));
        }else{
            mes = Fecha1.substring(3, 5);
            //parseInt(
            xhoy.setMonth(mes - 1); //en javascript los meses van de 0 a 11
            xhoy.setDate(Fecha1.substring(0, 2));
            xhoy.setYear(Fecha1.substring(6, 10));
        }
        xanio = xhoy.getFullYear();
        xmes = xhoy.getMonth() + 1;
        xdia = xhoy.getDate();
    }else{
        xhoy = new Date(Fecha1);
        xanio = xhoy.getFullYear();
        xmes = xhoy.getMonth() + 1;
        xdia = xhoy.getDate();
    }
    xfecnac = new Date(Fecha2);
    yanio = xfecnac.getFullYear();
    ymes = xfecnac.getMonth() + 1;
    ydia = xfecnac.getDate();
    ranios = MostrarEdad(xanio, xmes, xdia, yanio, ymes, ydia, "anios", 0, "rounddown");
    rmeses = MostrarEdad(xanio, xmes, xdia, (yanio + ranios), ymes, ydia, "meses", 0, "rounddown");
    rdias = MostrarEdad(xanio, xmes, xdia, (yanio + ranios), (ymes+rmeses), ydia, "dias", 0, "rounddown");
    return(ranios +  ' Años ' + rmeses + ' Meses ' + rdias + ' Dias');
}

function QuitarAcentosTxt(Text){
    var cadena = "";
    if(Text !== "" && Text !== null){
        for (var j = 0; j < Text.length; j++){
        switch(Text[j]){
            case "`":
                cadena+="&#96;";
                break;
            case "{":
                cadena+="&#123;";
                break;
            case "|":
                cadena+="&#124;";
                break;
            case "}":
                cadena+="&#125;";
                break;
            case "¡":
                cadena+="&#161;";
                break;
            case "¢":
                cadena+="&#162;";
                break;
            case "£":
                cadena+="&#163;";
                break;
            case "¤":
                cadena+="&#164;";
                break;
            case "¥":
                cadena+="&#165;";
                break;
            case "¦":
                cadena+="&#166;";
                break;
            case "§":
                cadena+="&#167;";
                break;
            case "¨":
                cadena+="&#168;";
                break;
            case "©":
                cadena+="&#169;";
                break;
            case "ª":
                cadena+="&#170;";
                break;
            case "«":
                cadena+="&#171;";
                break;
            case "®":
                cadena+="&#174;";
                break;
            case "¯":
                cadena+="&#175;";
                break;
            case "°":
                cadena+="&#176;";
                break;
            case "±":
                cadena+="&#177;";
                break;
            case "²":
                cadena+="&#178;";
                break;
            case "³":
                cadena+="&#179;";
                break;
            case "´":
                cadena+="&#180;";
                break;
            case "µ":
                cadena+="&#181;";
                break;
            case "¶":
                cadena+="&#182;";
                break;
            case "•":
                cadena+="&#183;";
                break;
            case "¸":
                cadena+="&#184;";
                break;
            case "¹":
                cadena+="&#185;";
                break;
            case "º":
                cadena+="&#186;";
                break;
            case "»":
                cadena+="&#187;";
                break;
            case "¼":
                cadena+="&#188;";
                break;
            case "¾":
                cadena+="&#190;";
                break;
            case "À":
                cadena+="&#192;";
                break;
            case "�?":
                cadena+="&#193;";
                break;
            case "Â":
                cadena+="&#194;";
                break;
            case "Ã":
                cadena+="&#195;";
                break;
            case "Ä":
                cadena+="&#196;";
                break;
            case "Å":
                cadena+="&#197;";
                break;
            case "Æ":
                cadena+="&#198;";
                break;
            case "Ç":
                cadena+="&#199;";
                break;
            case "È":
                cadena+="&#200;";
                break;
            case "É":
                cadena+="&#201;";
                break;
            case "Ê":
                cadena+="&#202;";
                break;
            case "Ë":
                cadena+="&#203;";
                break;
            case "Ì":
                cadena+="&#204;";
                break;
            case "�?":
                cadena+="&#205;";
                break;
            case "Î":
                cadena+="&#206;";
                break;
            case "�?":
                cadena+="&#207;";
                break;
            case "�?":
                cadena+="&#208;";
                break;
            case "Ñ":
                cadena+="&#209;";
                break;
            case "Ò":
                cadena+="&#210;";
                break;
            case "Ó":
                cadena+="&#211;";
                break;
            case "Ô":
                cadena+="&#212;";
                break;
            case "Õ":
                cadena+="&#213;";
                break;
            case "Ö":
                cadena+="&#214;";
                break;
            case "×":
                cadena+="&#215;";
                break;
            case "Ø":
                cadena+="&#216;";
                break;
            case "Ù":
                cadena+="&#217;";
                break;
            case "Ú":
                cadena+="&#218;";
                break;
            case "Û":
                cadena+="&#219;";
                break;
            case "Ü":
                cadena+="&#220;";
                break;
            case "�?":
                cadena+="&#221;";
                break;
            case "Þ":
                cadena+="&#222;";
                break;
            case "ß":
                cadena+="&#223;";
                break;
            case "à":
                cadena+="&#224;";
                break;
            case "á":
                cadena+="&#225;";
                break;
            case "â":
                cadena+="&#226;";
                break;
            case "ã":
                cadena+="&#227;";
                break;
            case "ä":
                cadena+="&#228;";
                break;
            case "å":
                cadena+="&#229;";
                break;
            case "æ":
                cadena+="&#230;";
                break;
            case "ç":
                cadena+="&#231;";
                break;
            case "è":
                cadena+="&#232;";
                break;
            case "é":
                cadena+="&#233;";
                break;
            case "ê":
                cadena+="&#234;";
                break;
            case "ë":
                cadena+="&#235;";
                break;
            case "ì":
                cadena+="&#236;";
                break;
            case "í":
                cadena+="&#237;";
                break;
            case "î":
                cadena+="&#238;";
                break;
            case "ï":
                cadena+="&#239;";
                break;
            case "ð":
                cadena+="&#240;";
                break;
            case "ñ":
                cadena+="&#241;";
                break;
            case "ò":
                cadena+="&#242;";
                break;
            case "ó":
                cadena+="&#243;";
                break;
            case "ô":
                cadena+="&#244;";
                break;
            case "õ":
                cadena+="&#245;";
                break;
            case "ö":
                cadena+="&#246;";
                break;
            case "÷":
                cadena+="&#247;";
                break;
            case "ø":
                cadena+="&#248;";
                break;
            case "ù":
                cadena+="&#249;";
                break;
            case "ú":
                cadena+="&#250;";
                break;
            case "û":
                cadena+="&#251;";
                break;
            case "ü":
                cadena+="&#252;";
                break;
            case "ý":
                cadena+="&#253;";
                break;
            case "þ":
                cadena+="&#254;";
                break;
            case "ÿ":
                cadena+="&#255;";
                break;
            case "Œ":
                cadena+="&#338;";
                break;
            case "œ":
                cadena+="&#339;";
                break;
            case "Š":
                cadena+="&#352;";
                break;
            case "š":
                cadena+="&#353;";
                break;
            case "Ÿ":
                cadena+="&#376;";
                break;
            case "ƒ":
                cadena+="&#402;";
                break;
            case "—":
                cadena+="&#8212;";
                break;
            case " ‘":
                cadena+="&#8216;";
                break;
            case "’":
                cadena+="&#8217;";
                break;
            case " “":
                cadena+="&#8220;";
                break;
            case "�?":
                cadena+="&#8221;";
                break;
            case "„":
                cadena+="&#8222;";
                break;
            case "†":
                cadena+="&#8224;";
                break;
            case "‡":
                cadena+="&#8225;";
                break;
            case "•":
                cadena+="&#8226;";
                break;
            case "…":
                cadena+="&#8230;";
                break;
            case "‰":
                cadena+="&#8240;";
                break;
            case "€":
                cadena+="&#8364;";
                break;
            case "™":
                cadena+="&#8482;";
                break;
            //case "<":
            //    cadena+="&#60;";
            //    break;
            //case ">":
            //    cadena+="&#62;";
            //    break;
            //case "~":
            //    cadena+="&#126;";
            //    break;
            //case "¬":
            //    cadena+="&#172;";
            //    break;
            default:
                cadena+=Text[j];
                break;
        }
    }
    }
    return cadena;
}

function PonerAcentosMayusculas(Text){
    var cadena = Text;
    if(cadena !== "" && cadena !== null){
        myRegExp = new RegExp("&#96;","g");  cadena = cadena.replace(myRegExp, "`");
        myRegExp = new RegExp("&#123;","g");  cadena = cadena.replace(myRegExp, "{");
        myRegExp = new RegExp("&#124;","g");  cadena = cadena.replace(myRegExp, "|");
        myRegExp = new RegExp("&#125;","g");  cadena = cadena.replace(myRegExp, "}");
        myRegExp = new RegExp("&#161;","g");  cadena = cadena.replace(myRegExp, "¡");
        myRegExp = new RegExp("&#162;","g");  cadena = cadena.replace(myRegExp, "¢");
        myRegExp = new RegExp("&#163;","g");  cadena = cadena.replace(myRegExp, "£");
        myRegExp = new RegExp("&#164;","g");  cadena = cadena.replace(myRegExp, "¤");
        myRegExp = new RegExp("&#165;","g");  cadena = cadena.replace(myRegExp, "¥");
        myRegExp = new RegExp("&#166;","g");  cadena = cadena.replace(myRegExp, "¦");
        myRegExp = new RegExp("&#167;","g");  cadena = cadena.replace(myRegExp, "§");
        myRegExp = new RegExp("&#168;","g");  cadena = cadena.replace(myRegExp, "¨");
        myRegExp = new RegExp("&#169;","g");  cadena = cadena.replace(myRegExp, "©");
        myRegExp = new RegExp("&#170;","g");  cadena = cadena.replace(myRegExp, "ª");
        myRegExp = new RegExp("&#171;","g");  cadena = cadena.replace(myRegExp, "«");
        myRegExp = new RegExp("&#173;","g");  cadena = cadena.replace(myRegExp, "­");
        myRegExp = new RegExp("&#174;","g");  cadena = cadena.replace(myRegExp, "®");
        myRegExp = new RegExp("&#175;","g");  cadena = cadena.replace(myRegExp, "¯");
        myRegExp = new RegExp("&#176;","g");  cadena = cadena.replace(myRegExp, "°");
        myRegExp = new RegExp("&#177;","g");  cadena = cadena.replace(myRegExp, "±");
        myRegExp = new RegExp("&#178;","g");  cadena = cadena.replace(myRegExp, "²");
        myRegExp = new RegExp("&#179;","g");  cadena = cadena.replace(myRegExp, "³");
        myRegExp = new RegExp("&#180;","g");  cadena = cadena.replace(myRegExp, "´");
        myRegExp = new RegExp("&#181;","g");  cadena = cadena.replace(myRegExp, "µ");
        myRegExp = new RegExp("&#182;","g");  cadena = cadena.replace(myRegExp, "¶");
        myRegExp = new RegExp("&#183;","g");  cadena = cadena.replace(myRegExp, "·");
        myRegExp = new RegExp("&#184;","g");  cadena = cadena.replace(myRegExp, "¸");
        myRegExp = new RegExp("&#185;","g");  cadena = cadena.replace(myRegExp, "¹");
        myRegExp = new RegExp("&#186;","g");  cadena = cadena.replace(myRegExp, "º");
        myRegExp = new RegExp("&#187;","g");  cadena = cadena.replace(myRegExp, "»");
        myRegExp = new RegExp("&#188;","g");  cadena = cadena.replace(myRegExp, "¼");
        myRegExp = new RegExp("&#189;","g");  cadena = cadena.replace(myRegExp, "½");
        myRegExp = new RegExp("&#190;","g");  cadena = cadena.replace(myRegExp, "¾");
        myRegExp = new RegExp("&#191;","g");  cadena = cadena.replace(myRegExp, "¿");
        myRegExp = new RegExp("&#192;","g");  cadena = cadena.replace(myRegExp, "À");
        myRegExp = new RegExp("&#193;","g");  cadena = cadena.replace(myRegExp, "�?");
        myRegExp = new RegExp("&#194;","g");  cadena = cadena.replace(myRegExp, "Â");
        myRegExp = new RegExp("&#195;","g");  cadena = cadena.replace(myRegExp, "Ã");
        myRegExp = new RegExp("&#196;","g");  cadena = cadena.replace(myRegExp, "Ä");
        myRegExp = new RegExp("&#197;","g");  cadena = cadena.replace(myRegExp, "Å");
        myRegExp = new RegExp("&#198;","g");  cadena = cadena.replace(myRegExp, "Æ");
        myRegExp = new RegExp("&#199;","g");  cadena = cadena.replace(myRegExp, "Ç");
        myRegExp = new RegExp("&#200;","g");  cadena = cadena.replace(myRegExp, "È");
        myRegExp = new RegExp("&#201;","g");  cadena = cadena.replace(myRegExp, "É");
        myRegExp = new RegExp("&#202;","g");  cadena = cadena.replace(myRegExp, "Ê");
        myRegExp = new RegExp("&#203;","g");  cadena = cadena.replace(myRegExp, "Ë");
        myRegExp = new RegExp("&#204;","g");  cadena = cadena.replace(myRegExp, "Ì");
        myRegExp = new RegExp("&#205;","g");  cadena = cadena.replace(myRegExp, "�?");
        myRegExp = new RegExp("&#206;","g");  cadena = cadena.replace(myRegExp, "Î");
        myRegExp = new RegExp("&#207;","g");  cadena = cadena.replace(myRegExp, "�?");
        myRegExp = new RegExp("&#208;","g");  cadena = cadena.replace(myRegExp, "�?");
        myRegExp = new RegExp("&#209;","g");  cadena = cadena.replace(myRegExp, "Ñ");
        myRegExp = new RegExp("&#210;","g");  cadena = cadena.replace(myRegExp, "Ò");
        myRegExp = new RegExp("&#211;","g");  cadena = cadena.replace(myRegExp, "Ó");
        myRegExp = new RegExp("&#212;","g");  cadena = cadena.replace(myRegExp, "Ô");
        myRegExp = new RegExp("&#213;","g");  cadena = cadena.replace(myRegExp, "Õ");
        myRegExp = new RegExp("&#214;","g");  cadena = cadena.replace(myRegExp, "Ö");
        myRegExp = new RegExp("&#215;","g");  cadena = cadena.replace(myRegExp, "×");
        myRegExp = new RegExp("&#216;","g");  cadena = cadena.replace(myRegExp, "Ø");
        myRegExp = new RegExp("&#217;","g");  cadena = cadena.replace(myRegExp, "Ù");
        myRegExp = new RegExp("&#218;","g");  cadena = cadena.replace(myRegExp, "Ú");
        myRegExp = new RegExp("&#219;","g");  cadena = cadena.replace(myRegExp, "Û");
        myRegExp = new RegExp("&#220;","g");  cadena = cadena.replace(myRegExp, "Ü");
        myRegExp = new RegExp("&#221;","g");  cadena = cadena.replace(myRegExp, "�?");
        myRegExp = new RegExp("&#222;","g");  cadena = cadena.replace(myRegExp, "Þ");
        myRegExp = new RegExp("&#223;","g");  cadena = cadena.replace(myRegExp, "ß");
        myRegExp = new RegExp("&#224;","g");  cadena = cadena.replace(myRegExp, "à");
        myRegExp = new RegExp("&#225;","g");  cadena = cadena.replace(myRegExp, "á");
        myRegExp = new RegExp("&#226;","g");  cadena = cadena.replace(myRegExp, "â");
        myRegExp = new RegExp("&#227;","g");  cadena = cadena.replace(myRegExp, "ã");
        myRegExp = new RegExp("&#228;","g");  cadena = cadena.replace(myRegExp, "ä");
        myRegExp = new RegExp("&#229;","g");  cadena = cadena.replace(myRegExp, "å");
        myRegExp = new RegExp("&#230;","g");  cadena = cadena.replace(myRegExp, "æ");
        myRegExp = new RegExp("&#231;","g");  cadena = cadena.replace(myRegExp, "ç");
        myRegExp = new RegExp("&#232;","g");  cadena = cadena.replace(myRegExp, "è");
        myRegExp = new RegExp("&#233;","g");  cadena = cadena.replace(myRegExp, "é");
        myRegExp = new RegExp("&#234;","g");  cadena = cadena.replace(myRegExp, "ê");
        myRegExp = new RegExp("&#235;","g");  cadena = cadena.replace(myRegExp, "ë");
        myRegExp = new RegExp("&#236;","g");  cadena = cadena.replace(myRegExp, "ì");
        myRegExp = new RegExp("&#237;","g");  cadena = cadena.replace(myRegExp, "í");
        myRegExp = new RegExp("&#238;","g");  cadena = cadena.replace(myRegExp, "î");
        myRegExp = new RegExp("&#239;","g");  cadena = cadena.replace(myRegExp, "ï");
        myRegExp = new RegExp("&#240;","g");  cadena = cadena.replace(myRegExp, "ð");
        myRegExp = new RegExp("&#241;","g");  cadena = cadena.replace(myRegExp, "ñ");
        myRegExp = new RegExp("&#242;","g");  cadena = cadena.replace(myRegExp, "ò");
        myRegExp = new RegExp("&#243;","g");  cadena = cadena.replace(myRegExp, "ó");
        myRegExp = new RegExp("&#244;","g");  cadena = cadena.replace(myRegExp, "ô");
        myRegExp = new RegExp("&#245;","g");  cadena = cadena.replace(myRegExp, "õ");
        myRegExp = new RegExp("&#246;","g");  cadena = cadena.replace(myRegExp, "ö");
        myRegExp = new RegExp("&#247;","g");  cadena = cadena.replace(myRegExp, "÷");
        myRegExp = new RegExp("&#248;","g");  cadena = cadena.replace(myRegExp, "ø");
        myRegExp = new RegExp("&#249;","g");  cadena = cadena.replace(myRegExp, "ù");
        myRegExp = new RegExp("&#250;","g");  cadena = cadena.replace(myRegExp, "ú");
        myRegExp = new RegExp("&#251;","g");  cadena = cadena.replace(myRegExp, "û");
        myRegExp = new RegExp("&#252;","g");  cadena = cadena.replace(myRegExp, "ü");
        myRegExp = new RegExp("&#253;","g");  cadena = cadena.replace(myRegExp, "ý");
        myRegExp = new RegExp("&#254;","g");  cadena = cadena.replace(myRegExp, "þ");
        myRegExp = new RegExp("&#255;","g");  cadena = cadena.replace(myRegExp, "ÿ");
        myRegExp = new RegExp("&#338;","g");  cadena = cadena.replace(myRegExp, "Œ");
        myRegExp = new RegExp("&#339;","g");  cadena = cadena.replace(myRegExp, "œ");
        myRegExp = new RegExp("&#352;","g");  cadena = cadena.replace(myRegExp, "Š");
        myRegExp = new RegExp("&#353;","g");  cadena = cadena.replace(myRegExp, "š");
        myRegExp = new RegExp("&#376;","g");  cadena = cadena.replace(myRegExp, "Ÿ");
        myRegExp = new RegExp("&#402;","g");  cadena = cadena.replace(myRegExp, "ƒ");
        myRegExp = new RegExp("&#8212;","g");  cadena = cadena.replace(myRegExp, "—");
        myRegExp = new RegExp("&#8216;","g");  cadena = cadena.replace(myRegExp, "‘");
        myRegExp = new RegExp("&#8217;","g");  cadena = cadena.replace(myRegExp, "’");
        myRegExp = new RegExp("&#8218;","g");  cadena = cadena.replace(myRegExp, "‚");
        myRegExp = new RegExp("&#8220;","g");  cadena = cadena.replace(myRegExp, "“");
        myRegExp = new RegExp("&#8221;","g");  cadena = cadena.replace(myRegExp, "�?");
        myRegExp = new RegExp("&#8222;","g");  cadena = cadena.replace(myRegExp, "„");
        myRegExp = new RegExp("&#8224;","g");  cadena = cadena.replace(myRegExp, "†");
        myRegExp = new RegExp("&#8225;","g");  cadena = cadena.replace(myRegExp, "‡");
        myRegExp = new RegExp("&#8226;","g");  cadena = cadena.replace(myRegExp, "•");
        myRegExp = new RegExp("&#8230;","g");  cadena = cadena.replace(myRegExp, "…");
        myRegExp = new RegExp("&#8240;","g");  cadena = cadena.replace(myRegExp, "‰");
        myRegExp = new RegExp("&#8364;","g");  cadena = cadena.replace(myRegExp, "€");
        myRegExp = new RegExp("&#8482;","g");  cadena = cadena.replace(myRegExp, "™");
    }
    return cadena;
}

function QuitarAcentosTxtMayusculas(Text){
    var cadena = "";
    if(Text !== "" && Text !== null){
        for (var j = 0; j < Text.length; j++){
        switch(Text[j]){
            case "`":
                cadena+="&#96;";
                break;
            case "{":
                cadena+="&#123;";
                break;
            case "|":
                cadena+="&#124;";
                break;
            case "}":
                cadena+="&#125;";
                break;
            case "¡":
                cadena+="&#161;";
                break;
            case "¢":
                cadena+="&#162;";
                break;
            case "£":
                cadena+="&#163;";
                break;
            case "¤":
                cadena+="&#164;";
                break;
            case "¥":
                cadena+="&#165;";
                break;
            case "¦":
                cadena+="&#166;";
                break;
            case "§":
                cadena+="&#167;";
                break;
            case "¨":
                cadena+="&#168;";
                break;
            case "©":
                cadena+="&#169;";
                break;
            case "ª":
                cadena+="&#170;";
                break;
            case "«":
                cadena+="&#171;";
                break;
            case "®":
                cadena+="&#174;";
                break;
            case "¯":
                cadena+="&#175;";
                break;
            case "°":
                cadena+="&#176;";
                break;
            case "±":
                cadena+="&#177;";
                break;
            case "²":
                cadena+="&#178;";
                break;
            case "³":
                cadena+="&#179;";
                break;
            case "´":
                cadena+="&#180;";
                break;
            case "µ":
                cadena+="&#181;";
                break;
            case "¶":
                cadena+="&#182;";
                break;
            case "•":
                cadena+="&#183;";
                break;
            case "¸":
                cadena+="&#184;";
                break;
            case "¹":
                cadena+="&#185;";
                break;
            case "º":
                cadena+="&#186;";
                break;
            case "»":
                cadena+="&#187;";
                break;
            case "¼":
                cadena+="&#188;";
                break;
            case "¾":
                cadena+="&#190;";
                break;
            case "À":
                cadena+="&#192;";
                break;
            case "�?":
                cadena+="&#193;";
                break;
            case "Â":
                cadena+="&#194;";
                break;
            case "Ã":
                cadena+="&#195;";
                break;
            case "Ä":
                cadena+="&#196;";
                break;
            case "Å":
                cadena+="&#197;";
                break;
            case "Æ":
                cadena+="&#198;";
                break;
            case "Ç":
                cadena+="&#199;";
                break;
            case "È":
                cadena+="&#200;";
                break;
            case "É":
                cadena+="&#201;";
                break;
            case "Ê":
                cadena+="&#202;";
                break;
            case "Ë":
                cadena+="&#203;";
                break;
            case "Ì":
                cadena+="&#204;";
                break;
            case "�?":
                cadena+="&#205;";
                break;
            case "Î":
                cadena+="&#206;";
                break;
            case "�?":
                cadena+="&#207;";
                break;
            case "�?":
                cadena+="&#208;";
                break;
            case "Ñ":
                cadena+="&#209;";
                break;
            case "Ò":
                cadena+="&#210;";
                break;
            case "Ó":
                cadena+="&#211;";
                break;
            case "Ô":
                cadena+="&#212;";
                break;
            case "Õ":
                cadena+="&#213;";
                break;
            case "Ö":
                cadena+="&#214;";
                break;
            case "×":
                cadena+="&#215;";
                break;
            case "Ø":
                cadena+="&#216;";
                break;
            case "Ù":
                cadena+="&#217;";
                break;
            case "Ú":
                cadena+="&#218;";
                break;
            case "Û":
                cadena+="&#219;";
                break;
            case "Ü":
                cadena+="&#220;";
                break;
            case "�?":
                cadena+="&#221;";
                break;
            case "Þ":
                cadena+="&#222;";
                break;
            case "ß":
                cadena+="&#223;";
                break;
            case "à":
                cadena+="&#224;";
                break;
            case "á":
                cadena+="&#225;";
                break;
            case "â":
                cadena+="&#226;";
                break;
            case "ã":
                cadena+="&#227;";
                break;
            case "ä":
                cadena+="&#228;";
                break;
            case "å":
                cadena+="&#229;";
                break;
            case "æ":
                cadena+="&#230;";
                break;
            case "ç":
                cadena+="&#231;";
                break;
            case "è":
                cadena+="&#232;";
                break;
            case "é":
                cadena+="&#233;";
                break;
            case "ê":
                cadena+="&#234;";
                break;
            case "ë":
                cadena+="&#235;";
                break;
            case "ì":
                cadena+="&#236;";
                break;
            case "í":
                cadena+="&#237;";
                break;
            case "î":
                cadena+="&#238;";
                break;
            case "ï":
                cadena+="&#239;";
                break;
            case "ð":
                cadena+="&#240;";
                break;
            case "ñ":
                cadena+="&#241;";
                break;
            case "ò":
                cadena+="&#242;";
                break;
            case "ó":
                cadena+="&#243;";
                break;
            case "ô":
                cadena+="&#244;";
                break;
            case "õ":
                cadena+="&#245;";
                break;
            case "ö":
                cadena+="&#246;";
                break;
            case "÷":
                cadena+="&#247;";
                break;
            case "ø":
                cadena+="&#248;";
                break;
            case "ù":
                cadena+="&#249;";
                break;
            case "ú":
                cadena+="&#250;";
                break;
            case "û":
                cadena+="&#251;";
                break;
            case "ü":
                cadena+="&#252;";
                break;
            case "ý":
                cadena+="&#253;";
                break;
            case "þ":
                cadena+="&#254;";
                break;
            case "ÿ":
                cadena+="&#255;";
                break;
            case "Œ":
                cadena+="&#338;";
                break;
            case "œ":
                cadena+="&#339;";
                break;
            case "Š":
                cadena+="&#352;";
                break;
            case "š":
                cadena+="&#353;";
                break;
            case "Ÿ":
                cadena+="&#376;";
                break;
            case "ƒ":
                cadena+="&#402;";
                break;
            case "—":
                cadena+="&#8212;";
                break;
            case " ‘":
                cadena+="&#8216;";
                break;
            case "’":
                cadena+="&#8217;";
                break;
            case " “":
                cadena+="&#8220;";
                break;
            case "�?":
                cadena+="&#8221;";
                break;
            case "„":
                cadena+="&#8222;";
                break;
            case "†":
                cadena+="&#8224;";
                break;
            case "‡":
                cadena+="&#8225;";
                break;
            case "•":
                cadena+="&#8226;";
                break;
            case "…":
                cadena+="&#8230;";
                break;
            case "‰":
                cadena+="&#8240;";
                break;
            case "€":
                cadena+="&#8364;";
                break;
            case "™":
                cadena+="&#8482;";
                break;
            //case "~":
            //    cadena+="&#126;";
            //    break;
            //case "¬":
            //    cadena+="&#172;";
            //    break;
            default:
                cadena+=Text[j];
                break;
        }
    }
    }
    return cadena;
}

function QuitarAcentos(Text){
    if(Text !== "" && Text !== null){
	var cadena="";
	var codigo="";
	for (var j = 0; j < Text.length; j++)
	{
		var Char=Text.charCodeAt(j);
		switch(Char)
		{
			case 225:
				cadena+="a";
				break;
			case 233:
				cadena+="e";
				break;
			case 237:
				cadena+="i";
				break;
			case 243:
				cadena+="o";
				break;
			case 250:
				cadena+="u";
				break;
			case 193:
				cadena+="A";
				break;
			case 201:
				cadena+="E";
				break;
			case 205:
				cadena+="I";
				break;
			case 211:
				cadena+="O";
				break;
			case 218:
				cadena+="U";
				break;
			case 241:
				cadena+="n";
				break;
			case 209:
				cadena+="N";
				break;
			case 45:
				cadena+="-";
				break;
			default:
				cadena+=Text.charAt(j);
			break;
		}
		codigo+="_"+Text.charCodeAt(j);
	}
	return cadena;
    }
}

function altoPanelSheduller(pAlto){
    var ajuste = (pAlto/967);
    return (pAlto - (180* ajuste));
}
function anchoPanelSheduller(pAncho){
    var ajuste = (pAncho/967);
    return (pAncho - (180* ajuste));
}

(function($){
    $.fn.onEnter = function(func) {
        this.bind('keypress', function(e) {
            if (parseInt(e.keyCode) === 13) func.apply(this, [e]);
        });
        return this;
     };
 })(jQuery);
 