<?php
/*
* @category    Controlador LogIn
* @package     Nube Apps - Planificador
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@nubeapps.com.co>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     Planificador Ver 1.0
* @license     COMERCIAL
* @link        http://www.nubeapps.com.co
* @country     Colombia
* @telephone   3168345866
*/
set_time_limit(0);
session_start();
require("configdb.php");
$task = isset($_REQUEST['task'])?$_REQUEST['task']:null;
switch ($task){
    case "login":
        loginUsuario();
        break;
    case "DESEA_ASIGNARCITA":
        deseaAsignarCita();
        break;
    case "CHECK_INASISTENCIA":
        checkInasistenciaCita();
        break;
    case "CHECK_CITASXCANCELAR":
        checkCitasCancelar();
        break;
    case "CANCELAR_CITA":
        cancelarCita();
        break;
    case "CHECK_CITASXORIGEN":
        verificarCitaxTipo();
        break;
    case "HISTORIAL_CITAS":
        historialCitas();
        break;
    case "COPAGOS_PENDIENTES":
        copagosPendientes();
        break;
    case "LISTAR_PROFESIONALESAGENDA":
        listarProfesionalesAgenda();
        break;
    case "LISTAR_FECHASAGENDA":
        listarFechasAgenda();
        break;
    case "LISTAR_HORARIOSAGENDA":
        listarHorariosAgenda();
        break;
    case "ASIGNAR_CITA":
        AsignarCitas();
        break;
    default:
        break;
}
function loginUsuario(){
    $pUsuario = isset($_REQUEST['user'])?$_REQUEST['user']:null;
    $pContrasena = isset($_REQUEST['pass'])?$_REQUEST['pass']:null;
    $gBaseDatos = new baseDatos();
    $gBaseDatos->conectar();
    $qry = 'CALL sp_usuario_loginasignarcitas("' . $pUsuario . '","' . $pContrasena . '")';
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($row[0]["idpaciente"] != ""){
        $_SESSION['ID_PACIENTE'] = htmlentities($row[0]["idpaciente"]);
        $_SESSION['NOM_PACIENTE'] = PonerAcentosHTML($row[0]["nomPaciente"]);
        $_SESSION['ID_EMPRESA'] = htmlentities($row[0]["Prestador"]);
        $_SESSION['ID_IPS'] = htmlentities($row[0]["IPS"]);
        $_SESSION['ESPACIENTE'] = "SI";
        $_SESSION['NOM_OPCION_MENU'] = "GESTION DE CITAS";
        $result =  utf8_encode('{"success":"true", "pPaciente":"' . $_SESSION['ID_PACIENTE'] . '", "msg":"Bienvenido"}');
        echo $result;
        exit;
    }else{
        echo '{"success": "false", "requestedId":"0"}';
    }
}
function deseaAsignarCita(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:null;
    $pOPC = isset($_REQUEST['pOPC'])?$_REQUEST['pOPC']:null;
    if($pOPC == "NO"){
        $gBaseDatos = new baseDatos();
        $gBaseDatos->conectar();
        $qry = "CALL sp_callcenter_nodeseaasignarcita('" . $pPaciente . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $result =  utf8_encode('{"success":"true", "pActivo":"NO", "msg":"Permitio"}');
        echo $result;
        exit;
    }else{
        $gBaseDatos = new baseDatos();
        $gBaseDatos->conectar();
        $qry = "CALL sp_callcenter_agentesactivos('" . $pPaciente . "')";
        //echo $qry;
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        if($row[0]["Permitidos"] > 0 || $row[0]["Permitidos"] == "" || $row[0]["Permitidos"] = "null" || $row[0]["Permitidos"] == null){
            $gBaseDatos = new baseDatos();
            $gBaseDatos->conectar();
            $qry = "CALL sp_callcenter_sideseaasignarcita('" . $pPaciente . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            $result =  utf8_encode('{"success":"true", "pActivo":"SI", "msg":"Permitio"}');
            echo $result;
            exit;
        }else{
            echo '{"success": "false", "requestedId":"0"}';
        }
    }
}
function checkInasistenciaCita(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:null;
    $gBaseDatos = new baseDatos();
    $gBaseDatos->conectar();
    $qry = "CALL sp_callcenter_checkinasistencia('" . $pPaciente . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
        $nRow = $row;
        foreach($row as $key => $val){
            //$nRow[$key] = $val;
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    echo json_encode($arr);
}
function checkCitasCancelar(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:null;
    $gBaseDatos = new baseDatos();
    $gBaseDatos->conectar();
    $qry = "CALL sp_callcenter_checkcitasxcancelar('" . $pPaciente . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
        $nRow = $row;
        foreach($row as $key => $val){
            //$nRow[$key] = $val;
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    echo json_encode($arr);
}
function cancelarCita(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:null;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:null;
    $pMotivo = isset($_REQUEST['pMotivo'])?$_REQUEST['pMotivo']:null;
    $pMotivoCancela = QuitarAcentosHTML($pMotivo);
    $gBaseDatos = new baseDatos();
    $gBaseDatos->conectar();
    $qry = "CALL sp_callcenter_cancelarcita('" . $pCAS . "',\"" . $pMotivoCancela . "\")";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $result =  utf8_encode('{"success":"true", "pCancelada":"SI", "msg":"Permitio"}');
    echo $result;
    exit;
}
function historialCitas(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:null;
    $gBaseDatos = new baseDatos();
    $gBaseDatos->conectar();
    $qry = "CALL sp_callcenter_historialcitas('" . $_SESSION['ID_IPS'] . "','" . $pPaciente . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
        $nRow = $row;
        foreach($row as $key => $val){
            //$nRow[$key] = $val;
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    echo json_encode($arr);
}
function copagosPendientes(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:null;
    $gBaseDatos = new baseDatos();
    $gBaseDatos->conectar();
    $qry = "CALL sp_callcenter_copagos('" . $_SESSION['ID_IPS'] . "','" . $pPaciente . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
        $nRow = $row;
        foreach($row as $key => $val){
            //$nRow[$key] = $val;
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    echo json_encode($arr);
}
function verificarCitaxTipo(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:null;
    $pTipo = isset($_REQUEST['pTipo'])?$_REQUEST['pTipo']:null;
    $gBaseDatos = new baseDatos();
    $gBaseDatos->conectar();
    if($pTipo == "MEDICINA"){
        $qry = "CALL sp_callcenter_ultimacitaxatencion('" . $pPaciente . "',\"%MED%\")";
    }else{
        $qry = "CALL sp_callcenter_ultimacitaxatencion('" . $pPaciente . "',\"%ODO%\")";
    }
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
        $nRow = $row;
        foreach($row as $key => $val){
            //$nRow[$key] = $val;
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    echo json_encode($arr);
}
function listarProfesionalesAgenda(){
    $pPaciente = isset($_REQUEST['Paciente'])?$_REQUEST['Paciente']:null;
    $TipoCita = isset($_REQUEST['TipoCita'])?$_REQUEST['TipoCita']:null;
    $gBaseDatos = new baseDatos();
    $gBaseDatos->conectar();
    $qry = "CALL sp_callcenter_listprofe_agenda('" . $pPaciente . "',\"" . $TipoCita . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
        $nRow = $row;
        foreach($row as $key => $val){
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    echo json_encode($arr);
}
function listarFechasAgenda(){
    $pProfesional = isset($_REQUEST['Profesional'])?$_REQUEST['Profesional']:null;
    $pPaciente = isset($_REQUEST['Paciente'])?$_REQUEST['Paciente']:null;
    $gBaseDatos = new baseDatos();
    $gBaseDatos->conectar();
    $qry = "CALL sp_callcenter_listfecha_agenda('" . $pProfesional . "','" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
        $nRow = $row;
        foreach($row as $key => $val){
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    echo json_encode($arr);
}
function listarHorariosAgenda(){
    $pAgenda = isset($_REQUEST['pAgenda'])?$_REQUEST['pAgenda']:null;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:null;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:null;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:null;
    $pCodBloqueo = "WEB_PAC_" . $pPaciente . "_CAS_" . $pCAS;
    $pNroHoras = isset($_REQUEST['pNroHoras'])?$_REQUEST['pNroHoras']:1;
    $gBaseDatos = new baseDatos();
    $gBaseDatos->conectar();
    $qry = "CALL sp_callcenter_listhora_agenda('" . $pAgenda . "',\"" . $pCodBloqueo . "\",'" . $pProfesional . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
        $nRow = $row;
        foreach($row as $key => $val){
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($arr);
    $Grupo = 0;
    $descHoraFin = "";
    //echo $pNroHoras . "malo - " . $pRegistros;
    $arrRes = array();
    for($i=0;$i<$pRegistros;$i++){
        $Grupo ++;
        $descHoraFin = "";
        if(($i+($pNroHoras-1))<$pRegistros){
            if($arr[$i]["GrupoCita"]==0){
                if($pNroHoras == 1){
                    $arrRes[$i]["Codigo"] = $arr[$i]["citaID"];
                    $arrRes[$i]["Descripcion"] = $arr[$i]["citaDescripcion"];
                }else{
                    for($j=1;$j<=$pNroHoras;$j++){
                        if($j==1){
                            $horaAct = substr($arr[$i]["IdCita"],-5);
                            $horaSig = substr($arr[$i+$j]["IdCita"],0,5);
                        }else{
                            $horaAct = $horaSig;
                            $horaSig = substr($arr[$i+$j]["IdCita"],0,5);
                        }
                        if($horaAct == $horaSig){
                            $arr[$i]["GrupoCita"] = $Grupo;
                            $arr[$i]["MostrarGrupoCita"] = 1;
                            for($k=1;$k<$pNroHoras;$k++){
                                $arr[$i+$k]["GrupoCita"] = $Grupo;
                                $descHoraFin = substr($arr[$i+$k]["citaDescripcion"],-8);
                            }
                            $arrRes[$i]["Codigo"] = $arr[$i]["citaID"];
                            $arrRes[$i]["Descripcion"] = $arr[$i]["citaDescripcion"] = substr($arr[$i]["citaDescripcion"],0,8) . $descHoraFin;
                        }
                    }
                }
            }
        }
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    echo json_encode($arrRes);
}
function AsignarCitas(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pPlan = isset($_REQUEST['pPlan'])?$_REQUEST['pPlan']:0;
    $pSubPlan = isset($_REQUEST['pSubPlan'])?$_REQUEST['pSubPlan']:0;
    $pContrato = isset($_REQUEST['pContrato'])?$_REQUEST['pContrato']:0;
    $pPrograma = isset($_REQUEST['pPrograma'])?$_REQUEST['pPrograma']:0;
    $pConcepto = isset($_REQUEST['pConcepto'])?$_REQUEST['pConcepto']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pFechaCita = isset($_REQUEST['pFecha'])?$_REQUEST['pFecha']:null;
    $pAgenda = isset($_REQUEST['pAgenda'])?$_REQUEST['pAgenda']:0;
    $pHorario = isset($_REQUEST['pHorario'])?$_REQUEST['pHorario']:0;
    $pUsuario = 0;
    
    $anio = substr($pFechaCita, 0, 4);
    $mes = substr($pFechaCita, 5, 2);
    $dia = substr($pFechaCita, 8, 2);
    $fecCita = mktime(0,0,0,$mes,$dia,$anio);
    $diaSemanaCita = date("D",$fecCita);
    $horaCita = date("H",$fecCita);
    $OportunidadCita = OportunidadAsignacionCitas($fecCita);
    $gBaseDatos = new baseDatos();
    $gBaseDatos->conectar();
    $CodInsercion = "WEB_PAC_" . $pPaciente . "_CASORI_" . $pCAS . "-CONS-" . mt_rand(0,100000) . "-" . date("YHis");
    $qry = "CALL sp_web_asignarcitas_crearcas(\"" . $CodInsercion . "\",'" . $pPaciente . "','" . $pCAS . "','" . $pCliente . "','" .$pPlan . "','" . $pSubPlan . "','" . $pContrato . "','" . $pPrograma . "','" . $pConcepto . "','" . $pProfesional . "',\"" . $pFechaCita . "\",'" . $pAgenda . "','" . $pHorario . "','" . $pUsuario . "',\"" . $OportunidadCita . "\")";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_array($qry));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($CampoLlave[0] > 0){
        $qry = "CALL sp_web_asignarcitas_crearcas_detalle('" . $CampoLlave[0] . "','" . $pCAS . "','" . $pConcepto . "','" . $pUsuario . "')";
        $gBaseDatos->conectar();
        @mysqli_query($gBaseDatos->ConexionID, $qry);
        $gBaseDatos->cerrar();
        $pOportunidad = $OportunidadCita;
        $qry = "CALL sp_web_asignarcitas_actualizar_detalleagendas('" . $pHorario . "','" . $CampoLlave[0] . "','" . $pPaciente . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan  . "','" . $pContrato  . "','" . $pConcepto . "','" . $pUsuario . "','" . $pOportunidad  . "',\"1\")";
        //echo $qry;
        $gBaseDatos->conectar();
        @mysqli_query($gBaseDatos->ConexionID, $qry);
        $gBaseDatos->cerrar();
        //$result =  utf8_encode('{"success":"true", "pActivo":"NO", "msg":"Permitio"}');
        //echo $result;
        echo '{"success": "true", "IdCita":"' . $CampoLlave[0] . '"}';
    }else{
        echo '{"success": "false", "IdCita":"0"}';
    }
}

function PonerAcentosHTML($Texto){
    $txt = $Texto;
    $result = preg_replace('/&#96;/',"`",$txt);
    $result1 = preg_replace('/&#123;/',"{",$result);
    $result = preg_replace('/&#124;/',"|",$result1);
    $result1 = preg_replace('/&#125;/',"}",$result);
    $result = preg_replace('/&#161;/',"¡",$result1);
    $result1 = preg_replace('/&#162;/',"¢",$result);
    $result = preg_replace('/&#163;/',"£",$result1);
    $result1 = preg_replace('/&#164;/',"¤",$result);
    $result = preg_replace('/&#165;/',"¥",$result1);
    $result1 = preg_replace('/&#166;/',"¦",$result);
    $result = preg_replace('/&#167;/',"§",$result1);
    $result1 = preg_replace('/&#168;/',"¨",$result);
    $result = preg_replace('/&#169;/',"©",$result1);
    $result1 = preg_replace('/&#170;/',"ª",$result);
    $result = preg_replace('/&#171;/',"«",$result1);
    $result1 = preg_replace('/&#173;/',"­",$result);
    $result = preg_replace('/&#174;/',"®",$result1);
    $result1 = preg_replace('/&#175;/',"¯",$result);
    $result = preg_replace('/&#176;/',"°",$result1);
    $result1 = preg_replace('/&#177;/',"±",$result);
    $result = preg_replace('/&#178;/',"²",$result1);
    $result1 = preg_replace('/&#179;/',"³",$result);
    $result = preg_replace('/&#180;/',"´",$result1);
    $result1 = preg_replace('/&#181;/',"µ",$result);
    $result = preg_replace('/&#182;/',"¶",$result1);
    $result1 = preg_replace('/&#183;/',"·",$result);
    $result = preg_replace('/&#184;/',"¸",$result1);
    $result1 = preg_replace('/&#185;/',"¹",$result);
    $result = preg_replace('/&#186;/',"º",$result1);
    $result1 = preg_replace('/&#187;/',"»",$result);
    $result = preg_replace('/&#188;/',"¼",$result1);
    $result1 = preg_replace('/&#189;/',"½",$result);
    $result = preg_replace('/&#190;/',"¾",$result1);
    $result1 = preg_replace('/&#191;/',"¿",$result);
    $result = preg_replace('/&#192;/',"À",$result1);
    $result1 = preg_replace('/&#193;/',"Á",$result);
    $result = preg_replace('/&#194;/',"Â",$result1);
    $result1 = preg_replace('/&#195;/',"Ã",$result);
    $result = preg_replace('/&#196;/',"Ä",$result1);
    $result1 = preg_replace('/&#197;/',"Å",$result);
    $result = preg_replace('/&#198;/',"Æ",$result1);
    $result1 = preg_replace('/&#199;/',"Ç",$result);
    $result = preg_replace('/&#200;/',"È",$result1);
    $result1 = preg_replace('/&#201;/',"É",$result);
    $result = preg_replace('/&#202;/',"Ê",$result1);
    $result1 = preg_replace('/&#203;/',"Ë",$result);
    $result = preg_replace('/&#204;/',"Ì",$result1);
    $result1 = preg_replace('/&#205;/',"Í",$result);
    $result = preg_replace('/&#206;/',"Î",$result1);
    $result1 = preg_replace('/&#207;/',"Ï",$result);
    $result = preg_replace('/&#208;/',"Ð",$result1);
    $result1 = preg_replace('/&#209;/',"Ñ",$result);
    $result = preg_replace('/&#210;/',"Ò",$result1);
    $result1 = preg_replace('/&#211;/',"Ó",$result);
    $result = preg_replace('/&#212;/',"Ô",$result1);
    $result1 = preg_replace('/&#213;/',"Õ",$result);
    $result = preg_replace('/&#214;/',"Ö",$result1);
    $result1 = preg_replace('/&#215;/',"×",$result);
    $result = preg_replace('/&#216;/',"Ø",$result1);
    $result1 = preg_replace('/&#217;/',"Ù",$result);
    $result = preg_replace('/&#218;/',"Ú",$result1);
    $result1 = preg_replace('/&#219;/',"Û",$result);
    $result = preg_replace('/&#220;/',"Ü",$result1);
    $result1 = preg_replace('/&#221;/',"Ý",$result);
    $result = preg_replace('/&#222;/',"Þ",$result1);
    $result1 = preg_replace('/&#223;/',"ß",$result);
    $result = preg_replace('/&#224;/',"à",$result1);
    $result1 = preg_replace('/&#225;/',"á",$result);
    $result = preg_replace('/&#226;/',"â",$result1);
    $result1 = preg_replace('/&#227;/',"ã",$result);
    $result = preg_replace('/&#228;/',"ä",$result1);
    $result1 = preg_replace('/&#229;/',"å",$result);
    $result = preg_replace('/&#230;/',"æ",$result1);
    $result1 = preg_replace('/&#231;/',"ç",$result);
    $result = preg_replace('/&#232;/',"è",$result1);
    $result1 = preg_replace('/&#233;/',"é",$result);
    $result = preg_replace('/&#234;/',"ê",$result1);
    $result1 = preg_replace('/&#235;/',"ë",$result);
    $result = preg_replace('/&#236;/',"ì",$result1);
    $result1 = preg_replace('/&#237;/',"í",$result);
    $result = preg_replace('/&#238;/',"î",$result1);
    $result1 = preg_replace('/&#239;/',"ï",$result);
    $result = preg_replace('/&#240;/',"ð",$result1);
    $result1 = preg_replace('/&#241;/',"ñ",$result);
    $result = preg_replace('/&#242;/',"ò",$result1);
    $result1 = preg_replace('/&#243;/',"ó",$result);
    $result = preg_replace('/&#244;/',"ô",$result1);
    $result1 = preg_replace('/&#245;/',"õ",$result);
    $result = preg_replace('/&#246;/',"ö",$result1);
    $result1 = preg_replace('/&#247;/',"÷",$result);
    $result = preg_replace('/&#248;/',"ø",$result1);
    $result1 = preg_replace('/&#249;/',"ù",$result);
    $result = preg_replace('/&#250;/',"ú",$result1);
    $result1 = preg_replace('/&#251;/',"û",$result);
    $result = preg_replace('/&#252;/',"ü",$result1);
    $result1 = preg_replace('/&#253;/',"ý",$result);
    $result = preg_replace('/&#254;/',"þ",$result1);
    $result1 = preg_replace('/&#255;/',"ÿ",$result);
    $result = preg_replace('/&#338;/',"Œ",$result1);
    $result1 = preg_replace('/&#339;/',"œ",$result);
    $result = preg_replace('/&#352;/',"Š",$result1);
    $result1 = preg_replace('/&#353;/',"š",$result);
    $result = preg_replace('/&#376;/',"Ÿ",$result1);
    $result1 = preg_replace('/&#402;/',"ƒ",$result);
    $result = preg_replace('/&#8212;/',"—",$result1);
    $result1 = preg_replace('/&#8216;/',"‘",$result);
    $result = preg_replace('/&#8217;/',"’",$result1);
    $result1 = preg_replace('/&#8218;/',"‚",$result);
    $result = preg_replace('/&#8220;/',"“",$result1);
    $result1 = preg_replace('/&#8221;/',"”",$result);
    $result = preg_replace('/&#8222;/',"„",$result1);
    $result1 = preg_replace('/&#8224;/',"†",$result);
    $result = preg_replace('/&#8225;/',"‡",$result1);
    $result1 = preg_replace('/&#8226;/',"•",$result);
    $result = preg_replace('/&#8230;/',"…",$result1);
    $result1 = preg_replace('/&#8240;/',"‰",$result);
    $result = preg_replace('/&#8364;/',"€",$result1);
    $result1 = preg_replace('/&#8482;/',"™",$result);
    $result = preg_replace('/&#60;/',"<",$result1);
    $result1 = preg_replace('/&#62;/',">",$result);
    return $result1;
}

function QuitarAcentosHTML($Texto){
    $txt = $Texto;
    $result = preg_replace('/À/',"&#192;",$txt);
    $result1 = preg_replace('/Á/',"&#193;",$result);
    $result = preg_replace('/Â/',"&#194;",$result1);
    $result1 = preg_replace('/Ã/',"&#195;",$result);
    $result = preg_replace('/Ä/',"&#196;",$result1);
    $result1 = preg_replace('/Å/',"&#197;",$result);
    $result = preg_replace('/È/',"&#200;",$result1);
    $result1 = preg_replace('/É/',"&#201;",$result);
    $result = preg_replace('/Ê/',"&#202;",$result1);
    $result1 = preg_replace('/Ë/',"&#203;",$result);
    $result = preg_replace('/Ì/',"&#204;",$result1);
    $result1 = preg_replace('/Í/',"&#205;",$result);
    $result = preg_replace('/Î/',"&#206;",$result1);
    $result1 = preg_replace('/Ï/',"&#207;",$result);
    $result1 = preg_replace('/Ñ/',"&#209;",$result);
    $result = preg_replace('/Ò/',"&#210;",$result1);
    $result1 = preg_replace('/Ó/',"&#211;",$result);
    $result = preg_replace('/Ô/',"&#212;",$result1);
    $result1 = preg_replace('/Õ/',"&#213;",$result);
    $result = preg_replace('/Ö/',"&#214;",$result1);
    $result1 = preg_replace('/Ù/',"&#217;",$result);
    $result = preg_replace('/Ú/',"&#218;",$result1);
    $result1 = preg_replace('/Û/',"&#219;",$result);
    $result = preg_replace('/Ü/',"&#220;",$result1);
    $result = preg_replace('/à/',"&#224;",$result1);
    $result1 = preg_replace('/á/',"&#225;",$result);
    $result = preg_replace('/â/',"&#226;",$result1);
    $result1 = preg_replace('/ã/',"&#227;",$result);
    $result = preg_replace('/ä/',"&#228;",$result1);
    $result1 = preg_replace('/å/',"&#229;",$result);
    $result = preg_replace('/è/',"&#232;",$result1);
    $result1 = preg_replace('/é/',"&#233;",$result);
    $result = preg_replace('/ê/',"&#234;",$result1);
    $result1 = preg_replace('/ë/',"&#235;",$result);
    $result = preg_replace('/ì/',"&#236;",$result1);
    $result1 = preg_replace('/í/',"&#237;",$result);
    $result = preg_replace('/î/',"&#238;",$result1);
    $result1 = preg_replace('/ï/',"&#239;",$result);
    $result1 = preg_replace('/ñ/',"&#241;",$result);
    $result = preg_replace('/ò/',"&#242;",$result1);
    $result1 = preg_replace('/ó/',"&#243;",$result);
    $result = preg_replace('/ô/',"&#244;",$result1);
    $result1 = preg_replace('/õ/',"&#245;",$result);
    $result = preg_replace('/ö/',"&#246;",$result1);
    $result1 = preg_replace('/ù/',"&#249;",$result);
    $result = preg_replace('/ú/',"&#250;",$result1);
    $result1 = preg_replace('/û/',"&#251;",$result);
    $result = preg_replace('/ü/',"&#252;",$result1);
    return $result;
}

function OportunidadAsignacionCitas($dateto, $datefrom = -1){
    date_default_timezone_set('America/Bogota');
    if($datefrom == -1) { 
        $datefrom = time(); 
        $dayfrom = date('D',$datefrom);
        $hourfrom = date('H',$datefrom);
    }
    $diastranscurridos = ($dateto - $datefrom) / (60*60*24);
    $semanastranscurridas = (int)($dateto - $datefrom) / (60*60*24*7);
    $res = round($diastranscurridos * 100) / 100;
    if ($hourfrom > 16){
        $res = $res - 1;
    }
    $res = $res - (int)$semanastranscurridas;
    return $res;
}